/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.camera;

import java.awt.event.MouseEvent;
import org.gwoptics.mathutils.VectorUtils;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PVector;

public final class Camera3D
implements PConstants {
    private PApplet _parent;
    private PVector _lookat;
    private PVector _up;
    private PVector _position;
    private float _nearLimit = 200.0f;
    private float _farLimit = 2000.0f;
    private float prevX;
    private float prevY;
    private PVector A = new PVector();
    private boolean _orthoView;
    private static Camera3D _cam;

    public void setLookat(PVector lookat) {
        this._lookat = lookat;
    }

    public void setPosition(PVector position) {
        this._position = position;
    }

    public void setNearLimit(float limit) {
        this._nearLimit = limit;
    }

    public void setFarLimit(float limit) {
        this._farLimit = limit;
    }

    public void setUpVector(PVector up) {
        this._up = up;
    }

    public float getNearLimit() {
        return this._nearLimit;
    }

    public float getFarLimit() {
        return this._farLimit;
    }

    public static PVector getPosition() {
        if (_cam == null) {
            return null;
        }
        return Camera3D._cam._position.get();
    }

    public static PVector getLookat() {
        if (_cam == null) {
            return null;
        }
        return Camera3D._cam._lookat.get();
    }

    public static PVector getUpVector() {
        if (_cam == null) {
            return null;
        }
        return Camera3D._cam._up.get();
    }

    public static PVector getEyeVector() {
        PVector eye = PVector.sub((PVector)Camera3D._cam._lookat, (PVector)Camera3D._cam._position);
        eye.normalize();
        return eye;
    }

    public static PVector getRightVector() {
        PVector up = Camera3D.getEyeVector();
        PVector eye = Camera3D.getUpVector();
        PVector right = up.cross(eye);
        right.normalize();
        return right;
    }

    public static PVector getRelativePosition() {
        return PVector.mult((PVector)PVector.sub((PVector)Camera3D._cam._lookat, (PVector)Camera3D._cam._position), (float)-1.0f);
    }

    public Camera3D(PApplet parent) {
        if (parent == null) {
            throw new NullPointerException("Can not except null parent.");
        }
        if (_cam != null) {
            throw new RuntimeException("A camera3D object has already been created.");
        }
        _cam = this;
        this._parent = parent;
        this._position = new PVector(100.0f, 100.0f, 100.0f);
        this._lookat = new PVector(0.0f, 0.0f, 0.0f);
        this._up = new PVector(0.0f, -1.0f, 0.0f);
        this._orthoView = false;
        this._parent.camera(this._position.x, this._position.y, this._position.z, this._lookat.x, this._lookat.y, this._lookat.z, this._up.x, this._up.y, this._up.z);
        parent.registerDraw((Object)this);
        parent.registerDispose((Object)this);
        parent.registerMouseEvent((Object)this);
    }

    public Camera3D(PApplet parent, boolean registerMouseEvents) {
        this(parent);
        if (!registerMouseEvents) {
            parent.unregisterMouseEvent((Object)this);
        }
    }

    public void dispose() {
        PApplet.println((String)"\nCamera disposed\n");
        _cam = null;
    }

    public void mouseEvent(MouseEvent event) {
        switch (event.getID()) {
            case 506: {
                float dx = this.prevX - (float)event.getX();
                float dy = this.prevY - (float)event.getY();
                if (this._parent.mouseButton == 37 && !event.isControlDown()) {
                    PVector relX = VectorUtils.rotateArbitaryAxis(Camera3D.getRelativePosition(), new PVector(0.0f, 1.0f, 0.0f), -dx * (float)Math.PI / 100.0f);
                    this._position = PVector.add((PVector)relX, (PVector)this._lookat);
                    float dAngle = dy * (float)Math.PI / 100.0f;
                    PVector r = Camera3D.getRelativePosition();
                    this.A = new PVector(0.0f, 0.0f, 1.0f);
                    float angle = (float)Math.atan2(r.x, r.z) + 1.5707964f;
                    this.A = VectorUtils.rotateArbitaryAxis(this.A, new PVector(0.0f, 1.0f, 0.0f), angle);
                    PVector relY = VectorUtils.rotateArbitaryAxis(r, this.A, dAngle);
                    if (Math.signum(r.x) == Math.signum(relY.x) && Math.signum(r.z) == Math.signum(relY.z)) {
                        this._position = PVector.add((PVector)relY, (PVector)this._lookat);
                    }
                }
                if (this._parent.mouseButton == 39 || this._parent.mouseButton == 37 && event.isControlDown()) {
                    PVector newPos = PVector.add((PVector)this._position, (PVector)PVector.mult((PVector)Camera3D.getEyeVector(), (float)(dy * 20.0f)));
                    PVector relPos = PVector.sub((PVector)newPos, (PVector)this._lookat);
                    if (relPos.mag() < this._nearLimit || relPos.mag() > this._farLimit) {
                        newPos = this._position;
                    }
                    this._position = newPos;
                }
                this.prevX = event.getX();
                this.prevY = event.getY();
                break;
            }
            case 503: {
                this.prevX = event.getX();
                this.prevY = event.getY();
            }
        }
    }

    public void setOrthographicView() {
        this._orthoView = true;
    }

    public void setPerspectiveView() {
        this._orthoView = false;
        float fov = 1.0471976f;
        float cameraZ = (float)((double)this._parent.height / 2.0 / Math.tan((double)fov / 2.0));
        this._parent.perspective(fov, (float)this._parent.width / (float)this._parent.height, (float)((double)cameraZ / 100.0), 20000.0f);
    }

    public void draw() {
        if (this._orthoView) {
            float orthoScale = 0.0012820513f;
            PVector new_pos = new PVector(this._position.x, this._position.y, this._position.z);
            float dist = 0.0012820513f * PVector.sub((PVector)new_pos, (PVector)this._lookat).mag();
            this._parent.ortho((float)(-this._parent.width) * dist, (float)this._parent.width * dist, (float)(-this._parent.height) * dist, (float)this._parent.height * dist, -10000.0f, 10000.0f);
            this._parent.camera(this._position.x, this._position.y, this._position.z, this._lookat.x, this._lookat.y, this._lookat.z, this._up.x, this._up.y, this._up.z);
        } else {
            this._parent.camera(this._position.x, this._position.y, this._position.z, this._lookat.x, this._lookat.y, this._lookat.z, this._up.x, this._up.y, this._up.z);
        }
    }
}

