/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D;

import java.util.ArrayList;
import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.Renderable;
import org.gwoptics.graphics.graph2D.Axis2D;
import org.gwoptics.graphics.graph2D.IGraph2D;
import org.gwoptics.graphics.graph2D.LabelPos;
import org.gwoptics.graphics.graph2D.backgrounds.IGraph2DBackground;
import org.gwoptics.graphics.graph2D.traces.IGraph2DTrace;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PVector;

public class Graph2D
extends Renderable
implements PConstants,
IGraph2D {
    protected Axis2D _ax;
    protected Axis2D _ay;
    protected float _xLength;
    protected float _yLength;
    protected GWColour _border;
    protected ArrayList<IGraph2DTrace> _traces;
    protected boolean _crossAxesAtZero;
    protected IGraph2DBackground _back;

    public void setXAxisTickSpacing(float s) {
        this._ax.setTickSpacing(s);
    }

    public void setYAxisTickSpacing(float s) {
        this._ay.setTickSpacing(s);
    }

    public void setXAxisMin(float val) {
        this._ax.setMinValue(val);
    }

    public void setXAxisMax(float val) {
        this._ax.setMaxValue(val);
    }

    public void setYAxisMin(float val) {
        this._ay.setMinValue(val);
    }

    public void setYAxisMax(float val) {
        this._ay.setMaxValue(val);
    }

    public void setXAxisLabel(String s) {
        this._ax.setAxisLabel(s);
    }

    public void setYAxisLabel(String s) {
        this._ay.setAxisLabel(s);
    }

    public void setXAxisLabelPos(LabelPos lblpos) {
        this._ax.setAxisLabelPos(lblpos);
    }

    public void setYAxisLabelPos(LabelPos lblpos) {
        this._ay.setAxisLabelPos(lblpos);
    }

    public void setXAxisLabelAccuracy(int l) {
        this._ax.setTickLabelAccuracy(l);
    }

    public void setYAxisLabelAccuracy(int l) {
        this._ay.setTickLabelAccuracy(l);
    }

    public void setXAxisMinorTicks(int n) {
        this._ax.setMinorTicks(n);
    }

    public void setYAxisMinorTicks(int n) {
        this._ay.setMinorTicks(n);
    }

    public void setAxisColour(int R, int G, int B) {
        this.setAxisColour(new GWColour(R, G, B));
    }

    public void setAxisColour(GWColour c) {
        if (c == null) {
            throw new NullPointerException("Colour argument cannot be null");
        }
        this._ax.setAxisColour(c);
        this._ay.setAxisColour(c);
    }

    public void setFontColour(int R, int G, int B) {
        this.setFontColour(new GWColour(R, G, B));
    }

    public void setFontColour(GWColour c) {
        if (c == null) {
            throw new NullPointerException("Colour argument cannot be null");
        }
        this._ax.setFontColour(c);
        this._ay.setFontColour(c);
    }

    public IGraph2DBackground getGraphBackground() {
        return this._back;
    }

    public Axis2D getXAxis() {
        return this._ax;
    }

    public Axis2D getYAxis() {
        return this._ay;
    }

    public void setNoBorder() {
        this._border = null;
    }

    public void setNoBackground() {
        this._back = null;
    }

    public void setBorderColour(int R, int G, int B) {
        this._border = new GWColour(R, G, B);
    }

    public void setBackground(IGraph2DBackground bk) {
        this._back = bk;
        this._back.setParent(this._parent);
        this._back.setAxes(this._ax, this._ay);
        this._back.setDimensions(this._ax.getLength(), this._ay.getLength());
    }

    public Graph2D(PApplet parent, int xLength, int yLength, boolean crossAxesAtZero) {
        super(parent);
        this._crossAxesAtZero = crossAxesAtZero;
        this._xLength = xLength;
        this._yLength = yLength;
        this._border = new GWColour(0, 0, 0);
        this._ax = new Axis2D(parent, xLength);
        this._ax.setTickLabelAlignment(Axis2D.Alignment.CENTER);
        this._ax.setAxesDirection(new PVector(1.0f, 0.0f));
        this._ax.setLabelDirection(new PVector(0.0f, 1.0f));
        this._ax.setAxisLabel("X-Axis");
        this._ay = new Axis2D(parent, yLength);
        this._ay.setTickLabelAlignment(Axis2D.Alignment.RIGHT);
        this._ay.setAxesDirection(new PVector(0.0f, -1.0f));
        this._ay.setLabelDirection(new PVector(-1.0f, 0.0f));
        this._ay.setLabelRotation(-1.5707964f);
        this._ay.setOffsetLabelByTickLength(true);
        this._ay.setAxisLabel("Y-Axis");
        if (this._crossAxesAtZero) {
            this._alignAxesToZero();
        }
        this._traces = new ArrayList();
    }

    protected void _alignAxesToZero() {
        float xPos = PApplet.constrain((int)this._ax.valueToPosition(0.0f), (int)0, (int)this._ax.getLength());
        float yPos = PApplet.constrain((int)this._ay.valueToPosition(0.0f), (int)0, (int)this._ay.getLength());
        this._ax.position.y = -yPos;
        this._ay.position.x = xPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addTrace(IGraph2DTrace trace) {
        if (trace == null) {
            throw new NullPointerException("Trace object can not be null.");
        }
        int ix = -1;
        ArrayList<IGraph2DTrace> arrayList = this._traces;
        synchronized (arrayList) {
            trace.setParent(this._parent);
            trace.setGraph(this);
            trace.onAddTrace(this._traces.toArray());
            trace.generate();
            this._traces.add(trace);
            ix = this._traces.size() - 1;
        }
        return ix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrace(IGraph2DTrace trace) {
        ArrayList<IGraph2DTrace> arrayList = this._traces;
        synchronized (arrayList) {
            trace.onRemoveTrace();
            this._traces.remove(trace);
        }
    }

    public void generateTrace(int index) {
        IGraph2DTrace t = this._traces.get(index);
        t.generate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw() {
        if (this._crossAxesAtZero) {
            this._alignAxesToZero();
        }
        this._parent.pushMatrix();
        this._parent.pushStyle();
        this._parent.translate(this.position.x, this.position.y + this._yLength);
        if (this._back != null) {
            this._back.draw();
        }
        if (this._border != null) {
            this._parent.stroke(this._border.toInt());
            this._parent.noFill();
            this._parent.rect(0.0f, 0.0f, this._xLength, -this._yLength);
        }
        ArrayList<IGraph2DTrace> arrayList = this._traces;
        synchronized (arrayList) {
            for (IGraph2DTrace t : this._traces) {
                t.draw();
            }
        }
        this._ax.draw();
        this._ay.draw();
        this._parent.popStyle();
        this._parent.popMatrix();
        this._parent.flush();
    }
}

