/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D.effects;

import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.colourmap.IColourmap;
import org.gwoptics.graphics.graph2D.effects.AxisColourmapEffect;

public class XAxisColourmapEffect
extends AxisColourmapEffect {
    public XAxisColourmapEffect(IColourmap map) {
        super(map);
    }

    public GWColour getPixelColour(int pos, int pos2, float xVal, float yVal) {
        if (!this._xaxisDataSet || !this._yaxisDataSet) {
            throw new RuntimeException("Axis data has not been set. Set using setXAxisValues and setYAxisValues before using.");
        }
        if (this._map.isCentreAtZero()) {
            if (this.xContainsZero) {
                float range = Math.max(Math.abs(this.xMax), Math.abs(this.xMin));
                return this._map.getColourAtLocation(1.0f - Math.abs(xVal - range) / (range * 2.0f));
            }
            float range = this.yMax - this.yMin;
            if (Math.signum(range) == 1.0f) {
                return this._map.getColourAtLocation(0.5f + (float)((double)(xVal - this.xMin) * 0.5 / (double)range));
            }
            if (Math.signum(range) == -1.0f) {
                return this._map.getColourAtLocation((float)((double)(xVal - this.xMin) * 0.5 / (double)range));
            }
        } else {
            return this._map.getColourAtLocation(Math.abs((xVal - this.xMin) / (this.xMax - this.xMin)));
        }
        return new GWColour(0, 0, 0);
    }
}

