/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D.traces;

import org.gwoptics.graphics.graph2D.Axis2D;
import org.gwoptics.graphics.graph2D.IGraph2D;
import org.gwoptics.graphics.graph2D.traces.IGraph2DTrace;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;

public abstract class Blank2DTrace
implements IGraph2DTrace {
    private IGraph2D _graphDrawable;
    private PApplet _parent;
    private PGraphics _backBuffer;
    private PImage _traceImg;
    private boolean _redraw;

    public void generate() {
        this._redraw = true;
    }

    public void onAddTrace(Object[] traces) {
    }

    public void onRemoveTrace() {
    }

    public void setPosition(int x, int y) {
    }

    public void setParent(PApplet parent) {
        if (parent == null) {
            throw new NullPointerException("Cannot assign a null PApplet object as a parent.");
        }
        this._parent = parent;
    }

    public void setGraph(IGraph2D grp) {
        if (grp == null) {
            throw new NullPointerException("Cannot assign a null graph2D object to draw on.");
        }
        if (this._graphDrawable != null) {
            throw new RuntimeException("A Graph2D object has already been set for this trace, other components may have already referenced the previous Graphs objects.");
        }
        if (this._parent == null) {
            throw new NullPointerException("Parent PApplet object is null.");
        }
        this._graphDrawable = grp;
        this._backBuffer = this._parent.createGraphics(grp.getXAxis().getLength(), grp.getYAxis().getLength(), "processing.core.PGraphics2D");
    }

    public void draw() {
        if (this._redraw) {
            this._backBuffer.beginDraw();
            Axis2D ax = this._graphDrawable.getXAxis();
            Axis2D ay = this._graphDrawable.getYAxis();
            float xoff = ax.valueToPosition(0.0f);
            float yoff = this._backBuffer.height - ay.valueToPosition(0.0f);
            this._backBuffer.translate(xoff, yoff);
            this._backBuffer.pushMatrix();
            float xscale = (float)ax.getLength() / (ax.getMaxValue() - ax.getMinValue());
            float yscale = (float)ay.getLength() / (ay.getMaxValue() - ay.getMinValue());
            this._backBuffer.scale(xscale, -yscale);
            this._backBuffer.background(0.0f, 0.0f, 0.0f, 0.0f);
            this.TraceDraw(this._backBuffer);
            this._backBuffer.popMatrix();
            this._backBuffer.endDraw();
            this._traceImg = this._backBuffer.get(0, 0, this._backBuffer.width, this._backBuffer.height);
            this._redraw = false;
        }
        this._parent.image(this._traceImg, 0.0f, (float)(-this._backBuffer.height));
    }

    public abstract void TraceDraw(PGraphics var1);
}

