/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.mathutils;

public class Complex {
    private double _re;
    private double _im;

    Complex() {
        this._im = 0.0;
        this._re = 0.0;
    }

    public Complex(double re, double im) {
        this._re = re;
        this._im = im;
    }

    public Complex(double re) {
        this._re = re;
        this._im = 0.0;
    }

    public void set(double re, double im) {
        this._re = re;
        this._im = im;
    }

    public void setReal(double re) {
        this._re = re;
    }

    public void setImag(double im) {
        this._im = im;
    }

    public void setAbsPhi(double amp, double phi) {
        Complex zz = Complex.scale(amp, Complex.exp(new Complex(0.0, phi)));
        this._re = zz._re;
        this._im = zz._im;
    }

    public static Complex newAbsPhi(double amp, double phi) {
        Complex zz = Complex.scale(amp, Complex.exp(new Complex(0.0, phi)));
        return zz;
    }

    public void add(Complex c) {
        this._re += c._re;
        this._im += c._im;
    }

    public static Complex add(Complex a, Complex b) {
        Complex zz = new Complex(0.0);
        zz._re = a._re + b._re;
        zz._im = a._im + b._im;
        return zz;
    }

    public void squared() {
        Complex zz = new Complex(0.0);
        zz._re = (this._re - this._im) * (this._re + this._im);
        zz._im = 2.0 * this._re * this._im;
        this._re = zz._re;
        this._im = zz._im;
    }

    public static Complex squared(Complex c) {
        Complex zz = new Complex(0.0);
        zz._re = (c._re - c._im) * (c._re + c._im);
        zz._im = 2.0 * c._re * c._im;
        return zz;
    }

    public double absSquared() {
        return this._re * this._re + this._im * this._im;
    }

    public static double absSquared(Complex c) {
        return c._re * c._re + c._im * c._im;
    }

    public double abs() {
        return Math.sqrt(this._re * this._re + this._im * this._im);
    }

    public static double abs(Complex c) {
        return Math.sqrt(c._re * c._re + c._im * c._im);
    }

    public double real() {
        return this._re;
    }

    public static double real(Complex c) {
        return c.real();
    }

    public double imag() {
        return this._im;
    }

    public static double imag(Complex c) {
        return c.imag();
    }

    public Complex sqrt() {
        double w;
        double r;
        double y;
        Complex cnull = new Complex(0.0);
        Complex z1 = new Complex(0.0);
        if (this._re == 0.0 && this._im == 0.0) {
            return cnull;
        }
        double x = Math.abs(this._re);
        if (x >= (y = Math.abs(this._im))) {
            r = y / x;
            w = Math.sqrt(x) * Math.sqrt(0.5 * (1.0 + Math.sqrt(1.0 + r * r)));
        } else {
            r = x / y;
        }
        w = Math.sqrt(y) * Math.sqrt(0.5 * (r + Math.sqrt(1.0 + r * r)));
        if (this._re >= 0.0) {
            z1.set(w, this._im / (2.0 * w));
        } else {
            double t_im = this._im >= 0.0 ? w : -w;
            z1.set(this._im / (2.0 * t_im), t_im);
        }
        if (Complex.isNaN(z1)) {
            throw new RuntimeException("division by zero");
        }
        return z1;
    }

    public static Complex sqrt(Complex z) {
        double w;
        double y;
        Complex cnull = new Complex(0.0);
        Complex z1 = new Complex(0.0);
        if (z.real() == 0.0 && z.imag() == 0.0) {
            return cnull;
        }
        double x = Math.abs(z.real());
        if (x >= (y = Math.abs(z.imag()))) {
            double r = y / x;
            w = Math.sqrt(x) * Math.sqrt(0.5 * (1.0 + Math.sqrt(1.0 + r * r)));
        } else {
            double r = x / y;
            w = Math.sqrt(y) * Math.sqrt(0.5 * (r + Math.sqrt(1.0 + r * r)));
        }
        if (z._re >= 0.0) {
            z1.set(w, z.imag() / (2.0 * w));
        } else {
            double t_im = z.imag() >= 0.0 ? w : -w;
            z1.set(z.imag() / (2.0 * t_im), t_im);
        }
        if (Complex.isNaN(z1)) {
            throw new RuntimeException("division by zero");
        }
        return z1;
    }

    public void inv() {
        double tmp_d = 1.0 / Complex.absSquared(this);
        if (Double.isNaN(tmp_d)) {
            throw new RuntimeException("division by zero");
        }
        this._re *= tmp_d;
        this._im = -1.0 * this._im * tmp_d;
    }

    public static Complex inv(Complex z) {
        Complex temp_z = new Complex(0.0);
        double tmp_d = 1.0 / Complex.absSquared(z);
        if (Double.isNaN(tmp_d)) {
            throw new RuntimeException("division by zero");
        }
        temp_z._re = z._re * tmp_d;
        temp_z._im = -1.0 * z._im * tmp_d;
        return temp_z;
    }

    public Double modulus() {
        double t1 = 0.0;
        double t2 = 0.0;
        double r = Math.abs(this._re);
        double i = Math.abs(this._im);
        if (r == 0.0) {
            t1 = i;
        } else if (i == 0.0) {
            t1 = r;
        } else if (r > i) {
            t2 = i / r;
            t1 = r * Math.sqrt(1.0 + t2 * t2);
        } else {
            t2 = r / i;
            t1 = i * Math.sqrt(1.0 + t2 * t2);
        }
        if (Double.isNaN(t1)) {
            throw new RuntimeException("division by zero");
        }
        return t1;
    }

    public static Double modulus(Complex z) {
        double t1 = 0.0;
        double t2 = 0.0;
        double r = Math.abs(z.real());
        double i = Math.abs(z.imag());
        if (r == 0.0) {
            t1 = i;
        } else if (i == 0.0) {
            t1 = r;
        } else if (r > i) {
            t2 = i / r;
            t1 = r * Math.sqrt(1.0 + t2 * t2);
        } else {
            t2 = r / i;
            t1 = i * Math.sqrt(1.0 + t2 * t2);
        }
        if (Double.isNaN(t1)) {
            throw new RuntimeException("division by zero");
        }
        return t1;
    }

    public void multiply(Complex b) {
        Complex zz = this;
        this._re = zz._re * b._re - zz._im * b._im;
        this._im = zz._im * b._re + zz._re * b._im;
    }

    public static Complex multiply(Complex a, Complex b) {
        Complex zz = new Complex(0.0);
        zz._re = a._re * b._re - a._im * b._im;
        zz._im = a._im * b._re + a._re * b._im;
        return zz;
    }

    public void divide(Complex b) {
        Complex z = this;
        if (Math.abs(b.real()) >= Math.abs(b.imag())) {
            double r = b.imag() / b.real();
            double den = b.real() + r * b.imag();
            this._re = (z.real() + r * z.imag()) / den;
            this._im = (z.imag() - r * z.real()) / den;
        } else {
            double r = b.real() / b.imag();
            double den = b.imag() + r * b.real();
            this._re = (r * z.real() + z.imag()) / den;
            this._im = (r * z.imag() - z.real()) / den;
        }
        if (Complex.isNaN(this)) {
            throw new RuntimeException("division by zero");
        }
    }

    public static Complex divide(Complex a, Complex b) {
        Complex z = new Complex(0.0);
        if (Math.abs(b.real()) >= Math.abs(b.imag())) {
            double r = b.imag() / b.real();
            double den = b.real() + r * b.imag();
            z.setReal((a.real() + r * a.imag()) / den);
            z.setImag((a.imag() - r * a.real()) / den);
        } else {
            double r = b.real() / b.imag();
            double den = b.imag() + r * b.real();
            z.setReal((r * a.real() + a.imag()) / den);
            z.setImag((r * a.imag() - a.real()) / den);
        }
        if (Complex.isNaN(z)) {
            throw new ArithmeticException("division by zero");
        }
        return z;
    }

    public void conj() {
        this._im *= -1.0;
    }

    public static Complex conj(Complex z) {
        return new Complex(z.real(), -1.0 * z.imag());
    }

    public void scale(Double x) {
        this._re *= x.doubleValue();
        this._im *= x.doubleValue();
    }

    public static Complex scale(Double x, Complex z) {
        return new Complex(z.real() * x, z.imag() * x);
    }

    public void scaleAndDelay(double amp, double phi) {
        Complex zz = this;
        this._re = amp * (zz._re * Math.cos(phi) - zz._im * Math.sin(phi));
        this._im = amp * (zz._re * Math.sin(phi) + zz._im * Math.cos(phi));
    }

    public static Complex scaleAndDelay(double amp, double phi, Complex z) {
        Complex zz = new Complex(0.0);
        zz._re = amp * (z._re * Math.cos(phi) - z._im * Math.sin(phi));
        zz._im = amp * (z._re * Math.sin(phi) + z._im * Math.cos(phi));
        return zz;
    }

    public static Complex pow(Complex z, int nom, int denom) {
        Complex c0 = new Complex(0.0);
        Complex c1 = new Complex(1.0);
        if (denom == 0) {
            throw new ArithmeticException("denominator is zero");
        }
        if (nom == 0) {
            return c1;
        }
        Double x = (double)nom / (double)denom;
        if (z.isEqual(c0)) {
            if (x > 0.0) {
                return c0;
            }
            throw new ArithmeticException("division by zero (1)");
        }
        if (nom == denom) {
            return z;
        }
        Complex z1 = Complex.log(z);
        z1._re *= x.doubleValue();
        z1._im *= x.doubleValue();
        if (Complex.isNaN(z1)) {
            throw new ArithmeticException("pow returns NaN");
        }
        return Complex.exp(z1);
    }

    public static Complex log(Complex z) {
        Complex z1 = new Complex(0.0);
        double x = Math.sqrt(z._re * z._re + z._im * z._im);
        z1._re = Math.log(x);
        z1._im = Math.atan2(z._im, z._re);
        if (Complex.isNaN(z1)) {
            throw new ArithmeticException("log returns NaN");
        }
        return z1;
    }

    public static Complex exp(Complex z) {
        Complex z1 = new Complex(0.0);
        double x = Math.exp(z._re);
        z1._re = x * Math.cos(z._im);
        z1._im = x * Math.sin(z._im);
        if (Complex.isNaN(z1)) {
            throw new ArithmeticException("exp returns NaN");
        }
        return z1;
    }

    public static Complex expi(Double phi) {
        Complex z1 = new Complex(Math.cos(phi), Math.sin(phi));
        if (Complex.isNaN(z1)) {
            throw new ArithmeticException("expi returns NaN");
        }
        return z1;
    }

    public boolean isNaN() {
        boolean t1 = Double.isNaN(this._re);
        boolean t2 = Double.isNaN(this._im);
        return t1 | t2;
    }

    public static boolean isNaN(Complex c) {
        boolean t1 = Double.isNaN(c._re);
        boolean t2 = Double.isNaN(c._im);
        return t1 | t2;
    }

    public boolean isEqual(Complex c) {
        boolean test = false;
        if (this.isNaN() && c.isNaN()) {
            test = true;
        } else if (this._re == c.real() && this._im == c.imag()) {
            test = true;
        }
        return test;
    }

    public static boolean isEqual(Complex a, Complex b) {
        boolean test = false;
        if (a.isNaN() && b.isNaN()) {
            test = true;
        } else if (a.real() == b.real() && a.imag() == b.imag()) {
            test = true;
        }
        return test;
    }

    public String toString() {
        char ch = '+';
        if (this._im < 0.0) {
            ch = '-';
        }
        return String.valueOf(this._re) + " " + ch + " " + Math.abs(this._im) + " i";
    }

    public static String toString(Complex z) {
        char ch = '+';
        if (z.imag() < 0.0) {
            ch = '-';
        }
        return String.valueOf(z.real()) + " " + ch + Math.abs(z.imag()) + " i";
    }
}

