/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.mathutils;

public final class TrigLookup {
    private static final int _accuracy = 100;
    private static final double[] _sinTable = new double[9001];
    private static final double DegtoRadian = Math.PI / 180;
    private static final double RadianToDeg = 57.29577951308232;

    static {
        int i = 0;
        while (i < _sinTable.length) {
            TrigLookup._sinTable[i] = Math.sin(Math.PI / 180 * (double)i / 100.0);
            ++i;
        }
    }

    public static double cos(float value) {
        return TrigLookup.sin(value + 1.5707964f);
    }

    public static double sin(float a) {
        int sign;
        float angle = (float)((double)a * 57.29577951308232);
        if (angle >= 360.0f) {
            angle %= 360.0f;
        }
        if (angle < 0.0f) {
            sign = -1;
            angle *= -1.0f;
        } else {
            sign = 1;
        }
        int ix = (int)(angle * 100.0f);
        if (ix < 18000) {
            if (ix < 9001) {
                return (double)sign * _sinTable[ix];
            }
            return (double)sign * _sinTable[18000 - ix];
        }
        if (ix < 27001) {
            return (double)(-sign) * _sinTable[ix - 18000];
        }
        return (double)(-sign) * _sinTable[36000 - ix];
    }
}

