public class Ball
{    
  // some local variables of the ball
  float x;
  float y;
  float xold;
  float yold;
  float xspeed;
  float yspeed;
  float phi;
  float phispeed;
  float xgravity;
  float ygravity;
  float friction;
  float phifriction;
  float wallfriction;
  float slowing;
  float reverseSpeed;
  float slowSpeed;
  PImage ball;
  boolean isAtRest;

  float xmin;
  float ymin;
  float xmax;
  float ymax;

  float phiscale;

  Ball(float tempX, float tempY)
  {
    ball=loadImage("ball.png");
    isAtRest = false;
    x = tempX;
    y = tempY;
    xspeed = 0;
    yspeed = 0;
    phi = 0;
    phispeed = 0;
    slowing=0.0;
    xgravity = -0.6*30.0/fps;
    ygravity = 0.6*30.0/fps;
    friction = 0.98;
    phifriction = 0.99;
    wallfriction=0.5;
    reverseSpeed = -0.98;
    slowSpeed = 0.99;
  }

  boolean loaded() {
    if (ball.width<=0)
    {
      return false;
    }
    else {
      return true;
    }
  }  

  void init() {
    xmin = ball.width/2.0;
    ymin = ball.height/2.0;
    //println("ball width and height: "+ball.width+"  " +ymin);
    xmax = width-ball.width/2.0;
    ymax = height-ball.height/2.0;
    phiscale =2.0/(ball.height);
  }

  void reset(float newX, float newY, float newXspeed, float newYspeed)
  {
    xold=x;
    yold=y;
    x=newX;
    y=newY;  
    xspeed=newXspeed;
    yspeed=newYspeed;
    isAtRest=false;
    bounce();
    twirl();
  }

  boolean isMoving() {
    return (!isAtRest);
  }

  void move()
  {
    isAtRest=false;
    xold=x;
    yold=y;
    y=y+yspeed;
    x=x+xspeed;

    bounce();
    twirl();

    /* check if ball is still moving */
    if ( y==yold && x==xold && phispeed<1)
    {
      slowing=slowing+1;
    }
    else
    {
      slowing=0.0;
    }
    /* wait roughly 2 seconds before setting ball to rest */
    if (slowing>2*fps) {
      isAtRest=true;  
      slowing=0.0;
    }
  }

  // bounce ball from walls
  void bounce() {
    if (y >= ymax)
    {
      yspeed = yspeed * reverseSpeed;
      xspeed = xspeed * slowSpeed;
      y = ymax;
    }
    if (y <= ymin)
    {
      yspeed = yspeed * reverseSpeed;
      xspeed = xspeed * slowSpeed;
      y = ymin;
    }
    if (x >= xmax)
    {
      xspeed = xspeed * reverseSpeed;
      yspeed = yspeed * slowSpeed;
      x = xmax;
    }
    if (x <= xmin)
    {
      xspeed = xspeed * reverseSpeed;
      yspeed = yspeed * slowSpeed;
      x = xmin;
    }

    /* change speed due to acceleration */
    xspeed=xspeed + xgravity * accelerometerX;
    yspeed=yspeed + ygravity * accelerometerY;

    /* apply frcition */
    xspeed=friction*xspeed; 
    yspeed=friction*yspeed;
  }

  // rotate the ball through friction with wall
  void twirl() { 
    phi=phi+phispeed;
    phispeed=phifriction*phispeed;

    /* if we are in contact with a wall, set rotational speed */
    if (y >= ymax)
    {
      phispeed=wall_speed(phispeed, x-xold);
    }
    if (y <= ymin)
    {
      phispeed=wall_speed(phispeed, -1.0*(x-xold));
    }
    if (x >= xmax)
    {
      phispeed=wall_speed(phispeed, -1.0*(y-yold));
    }
    if (x <= xmin)
    {
      phispeed=wall_speed(phispeed, y-yold);
    }
  }

  void display()
  {    
    pushStyle();
    pushMatrix();
    stroke(255);
    float offsetX=x;
    float offsetY=y;
    translate(offsetX, offsetY);
    rotate(phi);
    translate(-offsetX, -offsetY);
    /*
    fill(255);
     ellipse(x+ball_width/2, y+ball_height/2, ball_width, ball_height);
     stroke(150, 50, 50);
     line(x+ball_width/2, y+ball_height/2, x+0.8*ball_width, y+0.8*ball_height);
     */
    imageMode(CENTER);
    image(ball, x, y);
    popMatrix();
    popStyle();
  }

  float wall_speed(float oldphispeed, float speed2) {
    return wallfriction*oldphispeed+(1-wallfriction)*speed2*phiscale;
  }
}

