/**
 *  Copyright notice
 *  
 *  This file is part of the Processing sketch `GBViewer' 
 *  http://www.gwoptics.org/processing/gbviewer
 *  
 *  Copyright (C) 2009 onwards Daniel Brown and Andreas Freise
 *  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 *  MA  02110-1301, USA.
 */
 
import org.gwoptics.graphics.colourmap.IColourmap;

import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;
import guicomponents.G4P;
import guicomponents.GButton;
import guicomponents.GLabel;
import guicomponents.GTextField;
import guicomponents.GWinApplet;
import guicomponents.GWinData;
import guicomponents.GWindow;

@SuppressWarnings("serial")
public class ColourmapWindow extends GWindow {
	private IColourmap _map;
	PImage img = new PImage(80,380);
	
	GLabel lblR;
	GLabel lblG;
	GLabel lblB;
	GTextField txtR;
	GTextField txtG;
	GTextField txtB;
	GButton btnApply;  
	
	public ColourmapWindow(PApplet parent, IColourmap map, int x, int y) {		
		super(parent, "Colourmap Editor", x, y, 120, 510, false, PConstants.P2D);
		if(map == null){throw new NullPointerException("IColourmap argument cannot be null.");}
		
		this.setBackground(255);
		this.setResizable(true);
		
		_map = map;
		
		this.addDrawHandler(this, "draw");
		
		img.loadPixels();
		
		for (int i = 0; i < img.height; i++) {
			for (int j = 0; j < img.width; j++) {
				img.pixels[i*img.width +j] = _map.getIntAtLocation(i/(float)img.height);
			}
		}
		
		img.updatePixels();
		
		G4P.setMouseOverEnabled(true);	
		this.add(new GLabel(parent,"Red",10,400,40));
		this.add(new GTextField(parent,"0",50,400,60,20));
		this.add(new GLabel(parent,"Green",10,425,40));
		this.add(new GTextField(parent,"0",50,425,60,20));
		this.add(new GLabel(parent,"Blue",10,450,40));
		this.add(new GTextField(parent,"0",50,450,60,20));
		this.add(new GButton(parent, "Apply", 10, 475,100,25));
	}
	
	public void draw(GWinApplet appc, GWinData data){
		appc.background(200);
		appc.stroke(0);
		appc.rect(9, 9, 81, 381);
		appc.image(img, 10, 10);
	}
}
