/**
 *  Copyright notice
 *  
 *  This file is part of the Processing sketch `GBViewer' 
 *  http://www.gwoptics.org/processing/gbviewer
 *  
 *  Copyright (C) 2009 onwards Daniel Brown and Andreas Freise
 *  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 *  MA  02110-1301, USA.
 */ 

public enum GraphOptions {
	GUASS_AMP{
		@Override
		public GBViewerSettings getDefaultSettings(){
			GBViewerSettings s = new GBViewerSettings();
			
			s.nModeLabel = "n mode:";
			s.nModeMax = 10;
			s.nModeValue = 0;
			s.mModeLabel = "m mode:";	
			s.mModeMax = 10;
			s.mModeValue = 0;
			
			s.waistDistanceMax = 50;
			s.waistDistanceValue = 0;
						
			s.XYRangeMax = 2.0f;
			s.XYRangeMin = 1.0e-2f;
			s.XYRangeValue = 0.5f;

			s.ZRangeMax = 2000;
			s.ZRangeMin = 1;
			s.ZRangeValue = 700;
			
			return s;
		}
	},
	
	LAG_GAUSS_AMP{
		@Override
		public GBViewerSettings getDefaultSettings(){
			GBViewerSettings s = new GBViewerSettings();
			
			s.nModeLabel = "p mode:";
			s.nModeMax = 10;
			s.nModeValue = 0;
			s.mModeLabel = "l mode:";	
			s.mModeMax = 10;
			s.mModeValue = 0;
			
			s.waistDistanceMax = 50;
			s.waistDistanceValue = 0;
						
			s.XYRangeMax = 2.0f;
			s.XYRangeMin = 1.0e-2f;
			s.XYRangeValue = 0.5f;

			s.ZRangeMax = 2000;
			s.ZRangeMin = 1;
			s.ZRangeValue = 700;
			
			return s;
		}
	},
	
	SINU_LAG_AMP{
		@Override
		public GBViewerSettings getDefaultSettings(){
			GBViewerSettings s = new GBViewerSettings();
			
			s.nModeLabel = "p mode:";
			s.nModeMax = 10;
			s.nModeValue = 0;
			s.mModeLabel = "l mode:";	
			s.mModeMax = 10;
			s.mModeValue = 0;
			
			s.waistDistanceMax = 50;
			s.waistDistanceValue = 0;
						
			s.XYRangeMax = 2.0f;
			s.XYRangeMin = 1.0e-2f;
			s.XYRangeValue = 0.5f;

			s.ZRangeMax = 2000;
			s.ZRangeMin = 1;
			s.ZRangeValue = 700;
			
			return s;
		}
	};

	/**
	 * returns default settings for controls in application. 
	 * must be overridden by each option.
	 */
	public GBViewerSettings getDefaultSettings() {
		throw new RuntimeException("A possible graph option does not have any default settings defined. Create the" +
		" settings in GraphOptions enum by overriding getDefaultSettings().");
	}
}
