# These noise sources are fake! They are roughly based on the types of noises we actually see in the detectors
import numpy as np

def frequency_noise_ASD(f):
    f = np.array(f)
    return 1e4/abs(np.random.normal(f, 0, size=f.size))
    
def seismic_noise_ASD(f):
    f = np.array(f)
    N = 1e-4/abs(np.random.normal(f**15, 0, size=f.size))
    N += 1e-28
   
    return N

def thermal_noise_ASD(f):
    """
    See https://arxiv.org/pdf/gr-qc/0109073.pdf equation 24
    """
    kb = 1.38064852e-23
    T = 300
    Y = 7e10
    d = 5e-6
    w = 5e-2
    phi = 1e-6
    phi_s = 1e-8
    
    return np.sqrt(2*kb * T/((np.pi)**(3/2)*f) * (1/(w*Y))* (phi_s + 1/np.sqrt(np.pi) * d/w * 2* phi ))/np.sqrt(2)